@{
import sys
config = empy.config
}@
Escaped (0x0): @(config.escaped(0x0) == '\\x00' ? 'pass' ! 'fail').
Escaped (0x1): @(config.escaped(0x1) == '\\x01' ? 'pass' ! 'fail').
Escaped (0x11): @(config.escaped(0x11) == '\\x11' ? 'pass' ! 'fail').
Escaped (0x111): @(config.escaped(0x111) == '\\u0111' ? 'pass' ! 'fail').
Escaped (0x1111): @(config.escaped(0x1111) == '\\u1111' ? 'pass' ! 'fail').
Escaped (0x11111): @(config.escaped(0x11111) == '\\U00011111' ? 'pass' ! 'fail').

Has default prefix: @(config.hasDefaultPrefix() ? 'pass' ! 'fail').
@{
# Change it and change it back in a statement so it will have no other effect.
config.prefix = '$'
result = config.hasDefaultPrefix()
config.prefix = '@'
}@
Had default prefix: @(result ? 'fail' ! 'pass').

Buffering: @(config.buffering == config.defaultBuffering ? 'pass' ! 'fail').
@{config.setBuffering(8192)}@
Fixed buffering: @(config.hasFixedBuffering() ? 'pass' ! 'fail').
@{config.setBuffering('none')}@
No buffering: @(config.hasNoBuffering() ? 'pass' ! 'fail').
@{config.setBuffering('line')}@
Line buffering: @(config.hasLineBuffering() ? 'pass' ! 'fail').
@{config.setBuffering('full')}@
Full buffering: @(config.hasFullBuffering() ? 'pass' ! 'fail').
@{config.setBuffering('default')}@
Default (fixed) buffering: @(config.hasFixedBuffering() ? 'pass' ! 'fail').

Has binary: @(config.hasBinary() ? 'fail' ! 'pass').
@{config.enableBinary()}@
Enabled: @(config.hasBinary() ? 'pass' ! 'fail').
@{config.disableBinary()}@
Disabled: @(config.hasBinary() ? 'fail' ! 'pass').

Is default encoding/errors: @(config.isDefaultEncodingErrors(None, None) ? 'pass' ! 'fail').
Is default encoding/errors: @(config.isDefaultEncodingErrors('asdf', None) ? 'fail' ! 'pass').
Is default encoding/errors: @(config.isDefaultEncodingErrors(None, 'asdf') ? 'fail' ! 'pass').
Is default encoding/errors: @(config.isDefaultEncodingErrors('asdf', 'asdf') ? 'fail' ! 'pass').

Default encoding: @(config.getDefaultEncoding() == sys.getdefaultencoding() ? 'pass' ! 'fail').

Success code (yes): @(config.isSuccessCode(0) ? 'pass' ! 'fail').
Success code (no): @(config.isSuccessCode(1) ? 'fail' ! 'pass').

Is exit error (yes) @(config.isExitError(SystemExit()) ? 'pass' ! 'fail').
Is exit error (no) @(config.isExitError(IndexError()) ? 'fail' ! 'pass').

Error to exit code (SystemExit()): @(config.errorToExitCode(SystemExit()) == 0 ? 'pass' ! 'fail').
Error to exit code (SystemExit(0)): @(config.errorToExitCode(SystemExit(0)) == 0 ? 'pass' ! 'fail').
Error to exit code (SystemExit(2)): @(config.errorToExitCode(SystemExit(2)) == 2 ? 'pass' ! 'fail').
Error to exit code (IndexError()): @(config.errorToExitCode(IndexError()) == 1 ? 'pass' ! 'fail').

Is not an error (None): @(config.isNotAnError(None) ? 'pass' ! 'fail').
Is not an error (SystemExit()): @(config.isNotAnError(SystemExit()) ? 'pass' ! 'fail').
Is not an error (SystemExit(0)): @(config.isNotAnError(SystemExit(0)) ? 'pass' ! 'fail').
Is not an error (SystemExit(2)): @(config.isNotAnError(SystemExit(2)) ? 'fail' ! 'pass').
Is not an error (IndexError()): @(config.isNotAnError(IndexError()) ? 'fail' ! 'pass').
