@{
import em
import sys

class Core(em.Core):

    def evaluate(self, *args):
        sys.stdout.write('[' + args[0] + ']')
        return em.evalFunc(*args)

    def execute(self, *args):
        sys.stdout.write('[' + args[0] + ']')
        return em.execFunc(*args)

    def serialize(self, thing):
        return "'" + em.toString(thing) + "'"

    def define(self, signature, definition, locals=None):
        sys.stdout.write("[%s: %s]" % (signature, definition))

    def match(self, expression, casePairs, locals=None):
        sys.stdout.write("[%s: [%s]]" % (expression, ', '.join(
            [x[0] for x in casePairs])))

core = Core()
interp = em.Interpreter(core=core)
}@
@[with interp]@
@interp.expand("""\
Test expression: @(1 + 2 + 3).
Test statement: @{asdf = 16309}.
(asdf is now @asdf.)
Define: @[def x]Lorem ipsum@[end def].
(x is @[defined x]@x@[else]not defined@[end defined].)
Match: @[match dummy]@[case 123]case@[else]else@[end match].
""")@
@[end with]@
