@{
import em

class Extension(em.Extension):

    def parentheses(self, contents, depth, locals): return '((' + contents + '))'
    def square_brackets(self, contents, depth, locals): return '[[' + contents + ']]'
    def curly_braces(self, contents, depth, locals): return '{{' + contents + '}}'
    def angle_brackets(self, contents, depth, locals): return '<' + contents + '>'

interp = em.Interpreter(extension=Extension())
}@
@[with interp]@
@interp.expand("""Lorem ipsum!
@((This is a parenthesis extension.))
@[[This is a square brackets extension.]]
@{{This is a curly brace extension.}}
@<This is an angle bracket extension.>
""")@
@[end with]@
