@{
import em
import sys

def evalFunc(*args):
    sys.stdout.write('[' + args[0] + ']')
    return em.evalFunc(*args)

def execFunc(*args):
    sys.stdout.write('[' + args[0] + ']')
    return em.execFunc(*args)

def serializerFunc(thing):
    return "'" + em.toString(thing) + "'"

def definerFunc(signature, definition, locals=None):
    sys.stdout.write("[%s: %s]" % (signature, definition))

def matcherFunc(expression, casePairs, locals=None):
    sys.stdout.write("[%s: [%s]]" % (expression, ', '.join(
        [x[0] for x in casePairs])))

core = em.Core(
    evaluate=evalFunc,
    execute=execFunc,
    serialize=serializerFunc,
    define=definerFunc,
    match=matcherFunc)
}@
@empy.execute(open('tests/common/expand/expand.py').read())@
@expand("""\
Test expression: @(1 + 2 + 3).
Test statement: @{asdf = 16309}.
(asdf is now @asdf.)
Define: @[def x]Lorem ipsum@[end def].
(x is @[defined x]@x@[else]not defined@[end defined].)
Match: @[match dummy]@[case 123]case@[else]else@[end match].
""", core=core)@
