@{
import em

class Extension(em.Extension):

    def __init__(self):
        em.Extension.__init__(self, [('/', 'slashes')])

    def do(self, name, contents, depth, locals):
        return '[%s] "%s" (%s)' % (name, contents, depth)

    def parentheses(self, *args): return self.do('parentheses', *args)
    def square_brackets(self, *args): return self.do('square_brackets', *args)
    def curly_braces(self, *args): return self.do('curly_braces', *args)
    def angle_brackets(self, *args): return self.do('angle_brackets', *args)

    def slashes(self, *args): return self.do('slashes', *args)

empy.installExtension(Extension())
}@
@#
Parentheses: @((This is a test.))
Parentheses: @(((This is a test.)))
Parentheses: @((((This is a test.))))
Brackets: @[[This is a test.]]
Brackets: @[[[This is a test.]]]
Brackets: @[[[[This is a test.]]]]
Curly braces: @{{This is a test.}}
Curly braces: @{{{This is a test.}}}
Curly braces: @{{{{This is a test.}}}}
Angle brackets: @<This is a test.>
Angle brackets: @<<This is a test.>>
Angle brackets: @<<<This is a test.>>>
Angle brackets: @<<<<This is a test.>>>>
Slashes: @/This is a test./
Slashes: @//This is a test.//
Slashes: @///This is a test.///
Slashes: @////This is a test.////
