@{
import em

class Extension(em.Extension):

    def __init__(self):
        em.Extension.__init__(self, {
            '((': 'parens',
            '[[': 'brackets',
            '{{': 'braces',
            '<': 'angles',
            '/': 'slashes',
        })

    def do(self, name, contents, depth, locals):
        return '[%s] "%s" (%s)' % (name, contents, depth)

    def parens(self, *args): return self.do('parens', *args)
    def brackets(self, *args): return self.do('brackets', *args)
    def braces(self, *args): return self.do('braces', *args)
    def angles(self, *args): return self.do('angles', *args)

    def slashes(self, *args): return self.do('slashes', *args)

empy.installExtension(Extension())
}@
@#
Parentheses: @((This is a test.))
Parentheses: @(((This is a test.)))
Parentheses: @((((This is a test.))))
Brackets: @[[This is a test.]]
Brackets: @[[[This is a test.]]]
Brackets: @[[[[This is a test.]]]]
Curly braces: @{{This is a test.}}
Curly braces: @{{{This is a test.}}}
Curly braces: @{{{{This is a test.}}}}
Angle brackets: @<This is a test.>
Angle brackets: @<<This is a test.>>
Angle brackets: @<<<This is a test.>>>
Angle brackets: @<<<<This is a test.>>>>
Slashes: @/This is a test./
Slashes: @//This is a test.//
Slashes: @///This is a test.///
Slashes: @////This is a test.////
