import emlib
import sys

class Noop:

    def __call__(self, *args, **kwargs):
        pass


class Callable:

    def __init__(self, name, value):
        self.name = name
        self.value = value

    def __call__(self, *args, **kwargs):
        if self.value is not None:
            sys.stdout.write('[%s]' % self.name)
            return self.value


class Hook(emlib.AbstractHook):

    def __init__(self, *names):
        emlib.AbstractHook.__init__(self)
        self.names = names

    def __getattr__(self, name):
        if name in self.names:
            return Callable(name, self.value)
        else:
            return Noop()

    def set(self, value):
        self.value = value
