@{
import em

class Extension(em.Extension):

    def do(self, name, contents, depth, locals):
        return '[%s] "%s" (%s)' % (name, contents, depth)

    def parentheses(self, *args): return self.do('parentheses', *args)
    def square_brackets(self, *args): return self.do('square_brackets', *args)
    def curly_braces(self, *args): return self.do('curly_braces', *args)
    def angle_brackets(self, *args): return self.do('angle_brackets', *args)

empy.installExtension(Extension())
}@
@#
Parentheses: @((test))
Parentheses: @(((test)))
Parentheses: @((((test))))
Brackets: @[[test]]
Brackets: @[[[test]]]
Brackets: @[[[[test]]]]
Curly braces: @{{test}}
Curly braces: @{{{test}}}
Curly braces: @{{{{test}}}}
Angle brackets: @<test>
Angle brackets: @<<test>>
Angle brackets: @<<<test>>>
