@# Class
@{
import sys

import emlib

details = emlib.Details()
if not details.checkPythonVersion((3, 10)):
   # Only supported in versions of Python supporting the `match` control
   # structure.
   sys.exit(111)

class Point:
    def __init__(self, x, y):
        self.x = x
        self.y = y
}@
@# Function definition
@[def location(point)]@
@[  match point]@
@[    case Point(x=0, y=0)]@
Origin is the point's location.@
@[    case Point(x=0, y=y)]@
Y=@y and the point is on the y-axis.@
@[    case Point(x=x, y=0)]@
X=@x and the point is on the x-axis.@
@[    case Point(x=x, y=y) if x == y]@
The point is located on the Y=X diagonal.@
@[    case Point(x=x, y=y)]@
The point is located somewhere else on the plane.@
@[    else]@
Not a point.@
@[  end match]@
@[end def]@
@# Tests
Origin: @location(Point(x=0, y=0))
Y axis: @location(Point(x=0, y=5))
X axis: @location(Point(x=3, y=0))
Y=X diagonal: @location(Point(x=3, y=3))
None of the above: @location(Point(x=3, y=5))
Not a point: @location(123)
