@{
import sys

OK = ['FAIL', 'PASS']

# Don't use bools for Python 2.0.
def test(name, desc=None, asRepr=False):
    if desc is None:
        desc = name
    variable = empy.config.significatorFor(name)
    value1 = globals()[variable]
    value2 = empy.significators[name]
    result = value1
    if asRepr:
        result = repr(result)
    sys.stdout.write("%s: %s (%s)" % (desc, result, OK[value1 == value2]))
}@
@%blank
@test('blank', "Blank", True)
@%space
@test('space', "Space", True)
@%integer 16309
@test('integer', "Integer")
@%string "Lorem ipsum"
@test('string', "String")
@%stringtab	"Lorem ipsum"
@test('stringtab', "Tabbed string")
@%expression 1 + 2 + 3
@test('expression', "Expression")
@%function max(range(10))
@test('function', "Function")
@%literal [1, 2, 3]
@test('literal', "Literal")

@%duplicate 16309
@test('duplicate', 16309)
@%duplicate 90361
@test('duplicate', 90361)

@%!sblank
@test('sblank', "Stringized blank", True)
@%!sspace
@test('sspace', "Stringized space", True)
@%!sinteger 16309
@test('sinteger', "Stringized integer", True)
@%!sstring Lorem ipsum
@test('sstring', "Stringized string", True)
@%!sstringtab	Lorem ipsum
@test('sstringtab', "Stringized tabbed", True)
@%!squote "Lorem ipsum"
@test('squote', "Stringized quote", True)

@%%multi0 %%
@test('multi0', "Multiline blank", True)
@%%multi1 """Lorem ipsum"""%%
@test('multi1', "Multiline 1")
@%%multi2 """Lorem ipsum
dolor sit amet"""%%
@test('multi2', "Multiline 2")
@%%multi3 """Lorem ipsum
dolor sit amet,
consectetur adipiscing elit"""%%
@test('multi3', "Multiline 3")
@%%multi4 """Lorem ipsum
dolor sit amet,
consectetur adipiscing elit"""
%%
@test('multi4', "Multiline 4")
@%%multiliteral [1, 2, 3,
4, 5, 6,
7, 8, 9]%%
@test('multiliteral', "Multiline literal")

@%%!smulti0 %%
@test('smulti0', "Stringized multiline blank", True)
@%%!smulti1 Lorem ipsum%%
@test('smulti1', "Stringized multiline 1")
@%%!smulti2 Lorem ipsum
dolor sit amet%%
@test('smulti2', "Stringized multiline 2")
@%%!smulti3 Lorem ipsum
dolor sit amet,
consectetur adipiscing elit%%
@test('smulti3', "Stringized multiline 3")
@%%!smulti4 Lorem ipsum
dolor sit amet,
consectetur adipiscing elit
%%
@test('smulti4', "Stringized multiline 4")

@% whitespace1 "test"
@test('whitespace1')
@%! swhitespace1 test
@test('swhitespace1')
@%% whitespace2 "test" %%
@test('whitespace2')
@%%! swhitespace2 test %%
@test('swhitespace2')
