@# Test the behavior of functional expression markup with respect to currying.
@{
class Curry:

    def __init__(self, *args):
        self.args = args

    def __str__(self):
        return str(self.args)

    def __call__(self, *args):
        return Curry(*(self.args + args))
}@
No arguments: @Curry().
One argument: @Curry(1).
Two arguments: @Curry(1, 2).
One argument, then another: @Curry(1)(2).
One argument then functional: @Curry(1){2}.
One argument then two functional: @Curry(1){2}{3}.
This doesn't work: @Curry(1){2}{3}(4).
