@# Test whether locals dictionaries are respected.
@{
import sys

import em
import emlib

details = emlib.Details()
if not details.checkPythonVersion((3, 10)):
   # Only supported in versions of Python supporting the `match` control
   # structure.
   sys.exit(111)

class Manager:

    def __enter__(self): pass
    def __exit__(self, *exc): pass

class Extension(em.Extension):

    def angle_brackets(self, contents, depth, locals):
        self.interp.write(contents + ' [%s]' % locals.get('name'))

empy.installExtension(Extension())
}@
@# Test def.
@[def test_def(*a, **b)]@
@{name = 'function'}@
@[for x in name]@x@[end for]:@\s@
@<This is a function!>@
@[end def # test_def]@
@test_def()
@
@# Test match.
@[def test_match(*a, **b)]@
@[match 123]@
@{name = 'match'}@
@[case 'a']nope@
@[case (1, 2, 3)]nope@
@[case 123]@
@[for x in name]@x@[end for]:@\s@
@<This is a match!>@
@[end match # 123]@
@[end def # test_match]@
@test_match()
@
@# Test with.
@[def test_with(*a, **b)]@
@[with Manager() as m]@
@{name = 'with'}@
@[for x in name]@x@[end for]:@\s@
@<This is a with!>@
@[end with]@
@[end def # test_with]@
@test_with()
