@# The `match` core method now uses `Core.Case` instances rather than 2-tuples.
@# Test for backward compatibilty.  Only applies for `@[match]` support.
@{
import sys

import em
import emlib

details = emlib.Details()
if not details.checkPythonVersion((3, 10)):
   # Only supported in versions of Python supporting the `match` control
   # structure.
   sys.exit(111)

class DummyToken(em.ExpansionToken):

     def __init__(self, string='<dummy>'):
         self.string = string

     def scan(self, scanner):
         pass

     def run(self, interp, locals):
         interp.write(self.string)

cases = [
    ('123', [DummyToken('PASS')]),
    ('_', [DummyToken('FAIL')]),
]

sys.stdout.write("Testing: ")
empy.core.match('123', cases)
sys.stdout.write("\n")
}@
